﻿using VA.TMP.Integration.VIMT.Mvi.Mappers;
using VA.TMP.Integration.VIMT.Mvi.StateObject;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Mvi.PersonSearch.Messages;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Mvi.PipelineSteps.GetPersonIdentifiers
{
    /// <summary>
    /// Send Selected Person Request to EC step.
    /// </summary>
    public class SendSelectedPersonRequestToEcStep : FilterBase<GetPersonIdentifiersStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(GetPersonIdentifiersStateObject state)
        {
            if (state.IsSearchNeeded)
            {
                CorrespondingIdsResponse response;
                switch (state.SelectedPersonFakeResponseType)
                {
                    case "0":
                        response = PersonSearchUtilities.FakeSelectedPersonResponse(state);
                        break;

                    default:
                        response = state.SelectedPersonRequest.SendReceive<CorrespondingIdsResponse>(MessageProcessType.Local);
                        break;
                }

                state.CorrespondingIdsResponse = response;

                foreach (var id in response.CorrespondingIdList)
                {
                    state.CorrespondingIds.Add(MapGetPersonIdentifiersRequestToContact.Map(id));
                }
            }
            else
            {
                Logger.Instance.Debug("Already Have Identifiers from EDIPI search, skipping send to EC");
            }
        }
    }
}